/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWOperationParameterTableModel;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWOperationParametersPanel
extends JPanel {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWTable m_parameterTable = null;
    private VWOperationParameterTableModel m_parameterTableModel = null;
    private boolean m_isFirstTime = true;

    public VWOperationParametersPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_parameterTable != null) {
                int width = (this.m_parameterTable.getViewPortWidth() - 20) / 3;
                int[] columnSizes = new int[]{width, width - 30, 20, width + 30};
                this.m_parameterTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public String getSelectedParameterName() {
        try {
            return (String)this.m_parameterTableModel.getValueAt(this.m_parameterTable.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public String[] getSelectedParameterNames() {
        try {
            int[] nRows = this.m_parameterTable.getSelectedRows();
            if (nRows != null) {
                String[] names = new String[nRows.length];
                for (int nIndex = 0; nIndex < nRows.length; ++nIndex) {
                    names[nIndex] = (String)this.m_parameterTableModel.getValueAt(nRows[nIndex], 0);
                }
                return names;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isSelected(String itemName) {
        try {
            int[] nRows = this.m_parameterTable.getSelectedRows();
            if (nRows != null) {
                for (int nIndex = 0; nIndex < nRows.length; ++nIndex) {
                    String paramName = (String)this.m_parameterTableModel.getValueAt(nRows[nIndex], 0);
                    if (VWStringUtils.compare(paramName, itemName) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public void refreshUI() {
        try {
            this.m_parameterTableModel.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWStepDefinition stepDefinition, VWParameterDefinition[] paramDefs) {
        try {
            this.m_parameterTableModel.reinitialize(stepDefinition, paramDefs);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_operationParametersStr);
        this.add((Component)toolbarBorder, "Center");
        JPanel clientPanel = toolbarBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout());
        this.m_parameterTableModel = new VWOperationParameterTableModel(this.m_authPropertyData);
        this.m_parameterTable = new VWTable(this.m_parameterTableModel);
        this.m_parameterTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
        this.m_parameterTable.setDefaultRenderer(VWToolTipTableCellItem.class, new VWToolTipTableCellRenderer());
        TableColumn tcElement = this.m_parameterTable.getColumnModel().getColumn(3);
        if (tcElement != null) {
            tcElement.setCellEditor(new VWParamExpressionCellEditor(this.m_authPropertyData));
        }
        clientPanel.add((Component)new JScrollPane(this.m_parameterTable), "Center");
    }
}

